; $Id$
;
; Assembly language to record IR remote control signals. Parts of
; this program are taken from c't 1991, Heft 8 (pp 174 - 178).
;
; Chris Dodge - April 94
;
; Signal from detector read in "Paper Empty".
; Signal from timer read in "Busy".
;
				.MODEL	small
				.CODE
				PUBLIC 	@RecIR$qpzci   ; CPP mangled name for RecIR !
@RecIR$qpzci	PROC		NEAR
				push		bp
				mov			bp, sp
				push		si
				push 		ds
				mov     si, [bp+4]						; Get pointer to array
				mov			cx, [bp+6]						; Get size of array

; Identify printer port
				push		es						        ; Save ES and SI
				push		si

				mov			ax, 40h
				mov			es, ax
				mov			si, 0                 ; Printer port -> SI (lpt1 = 0)
				shl			si, 1
				mov			dx, es:[si+8]         ; Port address -> DX
				inc			dx		                ; Port status reg is 1 byte higher

				pop			si										; Pull ES and SI back
				pop			es
				mov			bx, 0                 ; Set counter to 0

				call		get_sequence

exit:		sti														; Allow interrupts again
				mov     ax, bx

				pop			ds
				pop			si
				pop			bp
				ret

@RecIR$qpzci	ENDP

get_sequence PROC NEAR

				cli                           ; Disable interrupts

S1:     mov			bx, 0                 ; Reset pointer

L1:     ; Start loop - wait until first IR impulse. A trigger is used
				; here; count the 120 "low" measurements. Noise signals
				; are usually shorter than this.

				in			al, dx
				and			al, 00100000b         ; Test to see if PE set low
				cmp			al, 0                 ;      (the GP1U52X holds high)
				jne			L1                    ; If high, then reset trigger counter

				mov			al, 00000001b
				mov			[si][bx], al 					; Write a "1" in the buffer
				inc			bx                    ; Incriment buffer pointer

L2:     ; Wait loop until BUSY is low, ie. can then take next input
				in			al, dx                ; Read value into AL
				mov			ah, al                ; Make backup in AH
				and			al, 10000000b					; Mask the BUSY bit...
				cmp			al, 10000000b					; ... and check if set
				je			L2

				mov			al, ah								; If BUSY bit not set, check PE
				and			al, 00100000b					; Mask PE ....
				cmp			al, 0									; ...and then write "1" or "0"
				je			P2										; in buffer

P1:		  cmp			bx, 90                ; Have we counter 120 0's yet? If
				jle			S1                    ; not, then noise so start again.
				mov			al, 00000001b					; Put a '1' in AL
				jmp			P3

P2:			mov			al, 00000000b					; Put a '0' in AL
				jmp			P3

P3:			mov			[si][bx], al					; Put the 1 or 0 in signal array
				inc			bx										; Incriment array pointer

S2:			; Loop until trigger is set to 0 again (BUSY low)
				in			al, dx
				mov			ah, al
				and			al, 10000000b
				cmp			al, 10000000b
				jne			S2

P4:			; Main loop - count until the signal array is full
				cmp			bx, cx
				jle			L2

				ret
get_sequence ENDP
				END